```	
	<!-- Include stylesheet -->
	<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">

	<!-- Create the editor container -->
	<div id="editor">
	  <p>Hello World!</p>
	  <p>Some initial <strong>bold</strong> text</p>
	  <p><br></p>
	</div>

	<!-- Include the Quill library -->
	<script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>

	<!-- Initialize Quill editor -->
	<script>
	  var quill = new Quill('#editor', {
		theme: 'snow'
	  });
	</script>
	
```

#### FOR FULL WIDGETS, USE MODULES AS BELOW
	
```
	var quill = new Quill('#editor', {
		modules: {
		'syntax': true,
		'toolbar': [
			[{ 'font': [] }, { 'size': [] }],
			[ 'bold', 'italic', 'underline', 'strike' ],
			[{ 'color': [] }, { 'background': [] }],
			[{ 'script': 'super' }, { 'script': 'sub' }],
			[{ 'header': '1' }, { 'header': '2' }, 'blockquote', 'code-block' ],
			[{ 'list': 'ordered' }, { 'list': 'bullet'}, { 'indent': '-1' }, { 'indent': '+1' }],
			[ 'direction', { 'align': [] }],
			[ 'link', 'image', 'video', 'formula' ],
			[ 'clean' ]
			]
		},
		placeholder: 'Type Email Here...',
		theme: 'snow'
	});
	
```

#### Triggers;

```
	quill.on('text-change', function(delta, source) {
		console.log('text changed');
	});
```